<?php
// Teil des Uploadmoduls von Mairu
defined ('main') or die ('no direct access');
// Funktion scandir fr PHP 4
if (version_compare(phpversion(), '5.0.0') == -1 AND !function_exists('scandir')) {
    function scandir($dir)
    {
        $dh = opendir($dir);
        while (false !== ($filename = readdir($dh))) $files[] = $filename;
        sort($files);
        return $files;
    }
}
// Funktion um einen String zu krzen, falls er zu lang ist
function short_string($string, $len = 20)
{
    if (strlen($string) <= $len) return $string;
    else {
        $len = floor($len / 2);
        $string = substr($string, 0, $len-3) . '...' . substr($string, $len * -1);
        return $string;
    }
}

// Funktion zur Analyse und Anpassen der .htaccess
function dir_access($dir, $mode = 'none')
{
    global $upload_htaccess;
    if (!$upload_htaccess) {
        return dir_access_index($dir,$mode);
    }
    switch ($mode) {
        case 'none':
            if (file_exists($dir . '.htaccess')) {
                $file = fopen($dir . '.htaccess', 'r') or die('Kann Datei .htaccess nicht &ouml;ffnen');
                $line = fread($file, 1024);
                fclose($file);
                if (preg_match("/\+Indexes/", $line) == 1) return (true);
                else return (false);
            } else return (false);
            break;
        case 'give':
            $file = fopen($dir . '.htaccess', 'w+') or die('Kann Datei .htaccess nicht &ouml;ffnen');
            fwrite($file, "Options +Indexes\n");
            fclose($file);
            break;
        case 'remove':
            $file = fopen($dir . '.htaccess', 'w+') or die('Kann Datei .htaccess nicht &ouml;ffnen');
            fwrite($file, "Options -Indexes\n");
            fclose($file);
            break;
    }
}

// Funktion zur Analyse und Anpassen einer index.html
function dir_access_index($dir, $mode)
{
    if (file_exists($dir . '.htaccess')) {
        @unlink($dir.'.htaccess');
    }
    switch ($mode) {
        case 'none':
            if (!file_exists($dir . 'index.html')) {
                return (true);
            }
            return (false);
            break;
        case 'remove':
            if (file_exists($dir . 'index.html')) {
                return (true);
            } else {
                $file = fopen($dir . 'index.html', 'w+') or die('Kann Datei index.htm nicht &ouml;ffnen');
                fwrite($file, '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/2000/REC-xhtml1-20000126/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="cs" lang="cs"><head><meta http-equiv="content-type" content="text/html; charset=iso-8859-2" />
<title>Kein Zugriff</title>
</head><body>
Kein Zugriff auf dieses Verzeichnis.
</body></html>');
                fclose($file);
            }
            break;
        case 'give':
            if (file_exists($dir . 'index.html')) {
                return (@unlink($dir.'index.html'));
            }
            break;
    }
}

// Funktion, die die Gre aller Dateien im Ordner zusammenrechnet
if (!function_exists('dirsize')) {
    function dirsize($dir)
    {
        $size = 0;
        $files = array_slice(scandir($dir), 2);
        foreach ($files as $filenr => $file) {
            if (is_dir($dir . $file)) {
                $size += dirsize($dir . $file . '/');
            } else {
                $size += @filesize($dir . $file);        
            }        
        }
        return $size;
    }
}

?>
